/* $Id: insrc.c,v 1.14 1998/07/20 22:35:42 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/* The module to be tested must have inputs as well as a source daughter
   board, located at LA of 8 and sema.bin must be installed into module 8
   before running this program */

#include <stdio.h>		/* For printf */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int     nchan, ninput, nsource;
    SHORTSIZ16 gchan, ginput, gsource;
    SHORTSIZ16 lchan[3], linput[2], lsource[1];

    int     i, status;
    FLOATSIZ64 buffer[1024];
    LONGSIZ32 count;
    SHORTSIZ16 laddr = 8;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);
    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel groups */
    nchan = 3;
    lchan[0] = E1432_INPUT_CHAN(1);
    lchan[1] = E1432_INPUT_CHAN(3);
    lchan[2] = E1432_SOURCE_CHAN(1);
    gchan = e1432_create_channel_group(hw, nchan, lchan);
    if (gchan >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    gchan));
	return -1;
    }

    ninput = 2;
    linput[0] = E1432_INPUT_CHAN(1);
    linput[1] = E1432_INPUT_CHAN(3);
    ginput = e1432_create_channel_group(hw, ninput, linput);
    if (ginput >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    ginput));
	return -1;
    }

    nsource = 1;
    lsource[0] = E1432_SOURCE_CHAN(1);
    gsource = e1432_create_channel_group(hw, nsource, lsource);
    if (gsource >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    gsource));
	return -1;
    }
    CHECK(e1432_set_active(hw, gsource, E1432_CHANNEL_ON));
    CHECK(e1432_set_source_mode(hw, gsource, E1432_SOURCE_MODE_BRAND));
    CHECK(e1432_set_ramp_rate(hw, gsource, 0.003));
    CHECK(e1432_auto_zero(hw, gsource));
    CHECK(e1432_set_trigger_channel(hw, gsource, E1432_CHANNEL_ON));
    CHECK(e1432_set_range(hw, gsource, 1.0));
    CHECK(e1432_set_amp_scale(hw, gsource, 0.999999));

    /* Initialize hardware things */
    for (i = 0; i < ninput; i++)
	CHECK(e1432_set_analog_input(hw, linput[i],
				     E1432_INPUT_MODE_VOLT,
				     E1432_INPUT_HIGH_NORMAL,
				     E1432_ANTI_ALIAS_ANALOG_ON,
				     E1432_COUPLING_DC, 1.0));
    CHECK(e1432_set_data_size(hw, gchan, E1432_DATA_SIZE_32));
    CHECK(e1432_set_auto_trigger(hw, gchan, E1432_MANUAL_TRIGGER));

    /* Start measurement, which also starts the source */
    CHECK(e1432_init_measure(hw, gchan));

    for ( ; ; )
    {
	/* Wait for input block available */
	while ((status = e1432_block_available(hw, ginput)) == 0);
	if (status > 0)
	    (void) printf("Block available found!\n");
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n"));
	    return -1;
	}

	for (i = 0; i < ninput; i++)
	{
	    /* Read some data */
	    CHECK(e1432_read_float64_data(hw, linput[i],
					  E1432_TIME_DATA, buffer,
					  1024, NULL, &count));
	    if (count != 1024)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }
#if 0
	    (void) printf("First four data samples:  %g, %g, %g, %g\n",
			  *buffer, *(buffer + 1),
			  *(buffer + 2), *(buffer + 3));
#endif
	}
    }
    /*NOTREACHED*/
    return 0;
}
